/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.library.util.cvu;

import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.cluster.install.ConfigurationSetup;
import oracle.cluster.install.UserInfo;
import oracle.cluster.verification.ClusterVerification;
import oracle.cluster.verification.InvalidPathException;
import oracle.cluster.verification.NodeConnectivityResultSet;
import oracle.cluster.verification.NodeResultsUnavailableException;
import oracle.cluster.verification.NodeRoleCapability;
import oracle.cluster.verification.OracleFileType;
import oracle.cluster.verification.OverallStatus;
import oracle.cluster.verification.PreReqNotSupportedException;
import oracle.cluster.verification.PreReqType;
import oracle.cluster.verification.SharedStorageResultSet;
import oracle.cluster.verification.SpaceResultSet;
import oracle.cluster.verification.VerificationError;
import oracle.cluster.verification.VerificationException;
import oracle.cluster.verification.VerificationResult;
import oracle.cluster.verification.VerificationResultSet;
import oracle.cluster.verification.VerificationTask;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.ProxyFactory;
import oracle.install.commons.util.Resource;
import oracle.install.commons.util.StringUtils;
import oracle.install.commons.util.exception.ErrorMessageHelper;
import oracle.install.commons.util.exception.ExceptionManager;
import oracle.install.commons.util.message.ContentType;
import oracle.install.commons.util.message.PlainContent;
import oracle.install.ivw.common.util.autoupdates.UpdatesHelper;
import oracle.install.library.resource.StringResourceBundle;

public class CVUHelper {
    public static final Resource resource = Application.getInstance().getResource(StringResourceBundle.class.getName());
    private static final Logger logger = Logger.getLogger(CVUHelper.class.getName());
    public static final String CRS_CLUVFY_ARGS = "stage -post crsinst -n";
    public static final String SIHA_CLUVFY_ARGS = "stage -post hacfg";
    private CVUOperationResultSet cvuOperResultSet;
    private boolean isResultSetDirty = false;
    private static CVUHelper instance;
    Resource stringResBundle = Application.getInstance().getResource("oracle.install.commons.util.resource.StringResourceBundle");

    public static synchronized CVUHelper getInstance() {
        ProxyFactory proxyFactory;
        if (instance == null && (instance = (CVUHelper)(proxyFactory = ProxyFactory.getInstance()).createProxy(CVUHelper.class)) == null) {
            instance = new CVUHelper();
        }
        return instance;
    }

    protected CVUHelper() {
    }

    private ClusterVerification getClusterVerification() throws VerificationException {
        this.cvuOperResultSet = new CVUOperationResultSet();
        this.isResultSetDirty = false;
        return ClusterVerification.getInstance();
    }

    private ClusterVerification getClusterVerification(String workDir, String frameworkHome) throws VerificationException {
        this.cvuOperResultSet = new CVUOperationResultSet();
        this.isResultSetDirty = false;
        return ClusterVerification.getInstance((String)workDir, (String)frameworkHome);
    }

    private ClusterVerification getClusterVerification(String path, ClusterVerification.PathType type) throws VerificationException {
        this.cvuOperResultSet = new CVUOperationResultSet();
        this.isResultSetDirty = false;
        return ClusterVerification.getInstance((String)path, (ClusterVerification.PathType)type);
    }

    public boolean isResultSetDirty() {
        return this.isResultSetDirty;
    }

    public void setResultSetDirty(boolean value) {
        this.isResultSetDirty = value;
    }

    public PlainContent getExtraDetails() {
        StringBuffer details;
        PlainContent content = null;
        if (this.cvuOperResultSet.getResultSet() != null) {
            logger.log(Level.INFO, "Overall status of CVU API call:" + this.cvuOperResultSet.getResultSet().getOverallStatus());
            content = this.getExtraDetails(this.cvuOperResultSet.getResultSet());
        }
        if (this.cvuOperResultSet.getResult() != null) {
            VerificationResult result = this.cvuOperResultSet.getResult();
            if (content == null) {
                content = new PlainContent("");
                content.setContentType(ContentType.HTML);
                content.setTitle(resource.getString("ErrorMessage.extraDetails.message", "Additional Information:", new Object[0]));
            }
            StringBuffer extraDetails = new StringBuffer();
            List errors = result.getErrors();
            for (VerificationError error : errors) {
                String message = error.getErrorMessage();
                String cause = error.getCause();
                String action = error.getAction();
                if (message != null) {
                    extraDetails.append("&nbsp;-&nbsp;");
                    extraDetails.append(StringUtils.textToHtml((String)message) + "<br>");
                }
                if (cause != null) {
                    extraDetails.append("&nbsp;-&nbsp;").append(this.stringResBundle.getString("ErrorMessage.details.titles.cause", "Cause *", new Object[0])).append(":&nbsp;");
                    extraDetails.append(StringUtils.textToHtml((String)cause) + "<br>");
                }
                if (action == null) continue;
                extraDetails.append("&nbsp;-&nbsp;").append(this.stringResBundle.getString("ErrorMessage.details.titles.action", "Action *", new Object[0])).append(":&nbsp;");
                extraDetails.append(StringUtils.textToHtml((String)action) + "<br>");
            }
            details = new StringBuffer(content.getContent());
            details.append(extraDetails.toString());
            content.setContent(details.toString());
        }
        if (this.cvuOperResultSet.getException() != null) {
            Exception exception = this.cvuOperResultSet.getException();
            if (content == null) {
                content = new PlainContent("");
                content.setContentType(ContentType.HTML);
                content.setTitle(resource.getString("ErrorMessage.extraDetails.message", "Additional Information:", new Object[0]));
            }
            StringBuffer detailsBuffer = new StringBuffer();
            ArrayList<String> causes = new ArrayList<String>();
            ExceptionManager.enumCauses((Throwable)exception, causes);
            causes.add(0, exception.getLocalizedMessage());
            if (!causes.isEmpty()) {
                String title = resource.getString("ErrorMessage.extraDetails.exceptionDetails", "Exception details", new Object[0]);
                detailsBuffer.append("<b>");
                detailsBuffer.append(title);
                detailsBuffer.append("</b>");
                for (String cause : causes) {
                    detailsBuffer.append("<br>");
                    detailsBuffer.append("&nbsp;-&nbsp;");
                    detailsBuffer.append(cause);
                }
                detailsBuffer.append("<br>");
                detailsBuffer.append("<br>");
            }
            if (Application.getInstance().getLogLevel() == Level.FINEST) {
                StringWriter out = new StringWriter();
                exception.printStackTrace(new PrintWriter(out));
                detailsBuffer.append("<pre>");
                detailsBuffer.append(out.toString());
                detailsBuffer.append("</pre>");
            }
            details = new StringBuffer(content.getContent());
            details.append(ErrorMessageHelper.formatMessage((Throwable)exception, (String)detailsBuffer.toString()));
            content.setContent(details.toString());
        }
        return content;
    }

    public PlainContent getExtraDetails(VerificationResultSet resultSet) {
        if (resultSet != null) {
            List failedNodes;
            StringBuffer extraDetails = new StringBuffer();
            List errors = resultSet.getErrors();
            for (VerificationError error : errors) {
                String message = error.getErrorMessage();
                String cause = error.getCause();
                String action = error.getAction();
                if (message != null) {
                    extraDetails.append("&nbsp;-&nbsp;");
                    extraDetails.append(StringUtils.textToHtml((String)message) + "<br>");
                }
                if (cause != null) {
                    extraDetails.append("&nbsp;-&nbsp;").append(this.stringResBundle.getString("ErrorMessage.details.titles.cause", "Cause *", new Object[0])).append(":&nbsp;");
                    extraDetails.append(StringUtils.textToHtml((String)cause) + "<br>");
                }
                if (action == null) continue;
                extraDetails.append("&nbsp;-&nbsp;").append(this.stringResBundle.getString("ErrorMessage.details.titles.action", "Action *", new Object[0])).append(":&nbsp;");
                extraDetails.append(StringUtils.textToHtml((String)action) + "<br>");
            }
            if (resultSet.hasNodeResults() && (failedNodes = resultSet.getFailedNodes()) != null && failedNodes.size() > 0) {
                extraDetails.append("<b>" + resource.getString("ErrorMessage.extraDetails.nodeSpecificErrors", "Summary of the failed nodes", new Object[0]) + "</b><br>");
                try {
                    List nodeResults = resultSet.getNodeResults();
                    if (nodeResults != null) {
                        for (VerificationResult nodeResult : nodeResults) {
                            String node = nodeResult.getNode();
                            if (!failedNodes.contains(node)) continue;
                            extraDetails.append("<b>" + node + "</b><br>");
                            List nodeSpecificErrors = nodeResult.getErrors();
                            for (VerificationError error : nodeSpecificErrors) {
                                String message = error.getErrorMessage();
                                String cause = error.getCause();
                                String action = error.getAction();
                                if (message != null) {
                                    extraDetails.append("&nbsp;-&nbsp;");
                                    extraDetails.append(StringUtils.textToHtml((String)message) + "<br>");
                                }
                                if (cause != null) {
                                    extraDetails.append("&nbsp;-&nbsp;").append(this.stringResBundle.getString("ErrorMessage.details.titles.cause", "Cause *", new Object[0])).append(":&nbsp;");
                                    extraDetails.append(StringUtils.textToHtml((String)cause) + "<br>");
                                }
                                if (action == null) continue;
                                extraDetails.append("&nbsp;-&nbsp;").append(this.stringResBundle.getString("ErrorMessage.details.titles.action", "Action *", new Object[0])).append(":&nbsp;");
                                extraDetails.append(StringUtils.textToHtml((String)action) + "<br>");
                            }
                        }
                    }
                }
                catch (NodeResultsUnavailableException e) {
                    logger.log(Level.INFO, "Exception while getting node results to display in extra details of error message", e);
                }
            }
            PlainContent content = new PlainContent(extraDetails.toString());
            ContentType contentType = ContentType.HTML;
            content.setContentType(contentType);
            content.setTitle(resource.getString("ErrorMessage.extraDetails.message", "Additional Information:", new Object[0]));
            return content;
        }
        return null;
    }

    public static String getPrereqXML(boolean applyUpdates, String downloadLocation) {
        File prereqFile;
        String autoUpdatesPrereqDir;
        String refDataFile;
        String prereqXML = null;
        String startupLocation = System.getProperty("oracle.installer.startup_location");
        String frameworkHome = startupLocation + "/../stage/cvu";
        prereqXML = refDataFile = frameworkHome + "/cvu_prereq.xml";
        String cmdLineXML = System.getProperty("oracle.install.cvu.prereq_xml_loc", "");
        if (cmdLineXML != null && cmdLineXML.length() > 0) {
            prereqXML = cmdLineXML;
        } else if (applyUpdates && downloadLocation != null && downloadLocation.length() > 0 && (autoUpdatesPrereqDir = UpdatesHelper.getInstance().getPrereqUpdateDir(downloadLocation)) != null && autoUpdatesPrereqDir.length() > 0 && (prereqFile = new File(autoUpdatesPrereqDir)) != null && prereqFile.length() > 0L && prereqFile.exists()) {
            prereqXML = prereqFile.getAbsolutePath();
        }
        return prereqXML;
    }

    public void setPreReqXmlFile(String file) throws VerificationException, InvalidPathException {
        this.getClusterVerification().setPreReqXmlFile(file);
    }

    public boolean isPreReqSupported() throws VerificationException {
        return this.getClusterVerification().isPreReqSupported();
    }

    public void setPreReqXmlFile(String prereqFile, String frameworkHome, ClusterVerification.PathType type) throws VerificationException, InvalidPathException {
        this.getClusterVerification(frameworkHome, type).setPreReqXmlFile(prereqFile);
    }

    public void setPreReqXmlFile(PreReqType prereqType, String prereqFile) throws VerificationException, InvalidPathException {
        this.getClusterVerification().setPreReqXmlFile(prereqType, prereqFile);
    }

    public void setFrameworkHome(String frameworkHome, ClusterVerification.PathType type) throws VerificationException {
        this.getClusterVerification(frameworkHome, type);
    }

    public List<VerificationTask> getPreReqTasksForSIDBInst() throws PreReqNotSupportedException, VerificationException {
        return this.getClusterVerification().getPreReqTasksForSIDBInst();
    }

    public void setVariableValue(String key, String value) throws VerificationException {
        this.getClusterVerification().setVariableValue(key, value);
    }

    public void clearVariableValue(String key) throws VerificationException {
        this.getClusterVerification().clearVariableValue(key);
    }

    public List<VerificationTask> getPreReqTasksForSIHAInst() throws PreReqNotSupportedException, VerificationException {
        return this.getClusterVerification().getPreReqTasksForSIHAInst();
    }

    public List<VerificationTask> getPreReqTasksForCRSInst(String[] nodes) throws PreReqNotSupportedException, VerificationException {
        return this.getClusterVerification().getPreReqTasksForCRSInst(nodes);
    }

    public List<VerificationTask> getPreReqTasksForCRSInst(String[] hubNodes, String[] autoNodes, String[] rimNodes, int targetHubSize) throws PreReqNotSupportedException, VerificationException {
        return this.getClusterVerification().getPreReqTasksForCRSInst(hubNodes, autoNodes, rimNodes, targetHubSize);
    }

    public List<VerificationTask> getPreReqTasksForDBInst(String[] nodes) throws PreReqNotSupportedException, VerificationException {
        return this.getClusterVerification().getPreReqTasksForDBInst(nodes);
    }

    public List<VerificationTask> getPreReqTasksForNodeAdd(String[] nodes) throws PreReqNotSupportedException, VerificationException {
        return this.getClusterVerification().getPreReqTasksForNodeAdd(nodes);
    }

    public List<VerificationTask> getPreReqTasksForNodeAdd(String[] nodeList, String[] nodeVIPList) throws PreReqNotSupportedException, VerificationException {
        return this.getClusterVerification().getPreReqTasksForNodeAdd(nodeList, nodeVIPList);
    }

    public List<VerificationTask> getPreReqTasksForNodeAdd(String[] nodeList, String[] nodeVIPList, NodeRoleCapability[] nodeRoles) throws PreReqNotSupportedException, VerificationException {
        return this.getClusterVerification().getPreReqTasksForNodeAdd(nodeList, nodeVIPList, nodeRoles);
    }

    public void setConditionValue(String condition, boolean value) throws VerificationException {
        this.getClusterVerification().setConditionValue(condition, value);
    }

    public VerificationResultSet checkCRSIntegrity(String[] nodes) throws VerificationException {
        try {
            VerificationResultSet resultSet = this.getClusterVerification().checkCRSIntegrity(nodes);
            this.cvuOperResultSet.setResultSet(resultSet);
            return resultSet;
        }
        catch (VerificationException e) {
            this.cvuOperResultSet.setException((Exception)((Object)e));
            throw e;
        }
    }

    public VerificationResult getCRSUser() throws UnsupportedOperationException, VerificationException {
        try {
            VerificationResult result = this.getClusterVerification().getCRSUser();
            this.cvuOperResultSet.setResult(result);
            return result;
        }
        catch (VerificationException e) {
            this.cvuOperResultSet.setException((Exception)((Object)e));
            throw e;
        }
        catch (UnsupportedOperationException e) {
            this.cvuOperResultSet.setException(e);
            throw e;
        }
    }

    public VerificationResult getSIHAUser() throws UnsupportedOperationException, VerificationException {
        try {
            VerificationResult result = this.getClusterVerification().getSIHAUser();
            this.cvuOperResultSet.setResult(result);
            return result;
        }
        catch (VerificationException e) {
            this.cvuOperResultSet.setException((Exception)((Object)e));
            throw e;
        }
        catch (UnsupportedOperationException e) {
            this.cvuOperResultSet.setException(e);
            throw e;
        }
    }

    public SpaceResultSet getAvailableSpace(String[] nodeList, String path, boolean isWritePermissionRequired) throws InvalidPathException, VerificationException {
        try {
            SpaceResultSet resultSet = this.getClusterVerification().getAvailableSpace(nodeList, path, isWritePermissionRequired);
            this.cvuOperResultSet.setResultSet((VerificationResultSet)resultSet);
            return resultSet;
        }
        catch (VerificationException e) {
            this.cvuOperResultSet.setException((Exception)((Object)e));
            throw e;
        }
        catch (InvalidPathException e) {
            this.cvuOperResultSet.setException((Exception)((Object)e));
            throw e;
        }
    }

    public VerificationResult checkGroupExistence(String groupName) throws VerificationException {
        try {
            VerificationResult result = this.getClusterVerification().checkGroupExistence(groupName);
            this.cvuOperResultSet.setResult(result);
            return result;
        }
        catch (VerificationException e) {
            this.cvuOperResultSet.setException((Exception)((Object)e));
            throw e;
        }
    }

    public VerificationResultSet checkNodeConnectivity(String[] nodeList, String interfaceName, String subnet) throws VerificationException {
        try {
            NodeConnectivityResultSet resultSet = this.getClusterVerification().checkNodeConnectivity(nodeList, interfaceName, subnet);
            this.cvuOperResultSet.setResultSet((VerificationResultSet)resultSet);
            return resultSet;
        }
        catch (VerificationException e) {
            this.cvuOperResultSet.setException((Exception)((Object)e));
            throw e;
        }
    }

    public VerificationResult checkPackage(String packageName, String minVersion) throws VerificationException {
        try {
            VerificationResult result = this.getClusterVerification().checkPackage(packageName, minVersion);
            this.cvuOperResultSet.setResult(result);
            return result;
        }
        catch (VerificationException e) {
            this.cvuOperResultSet.setException((Exception)((Object)e));
            throw e;
        }
    }

    public VerificationResultSet checkPackage(String[] nodes, String packageName, String minVersion) throws VerificationException {
        try {
            VerificationResultSet resultSet = this.getClusterVerification().checkPackage(nodes, packageName, minVersion);
            this.cvuOperResultSet.setResultSet(resultSet);
            return resultSet;
        }
        catch (VerificationException e) {
            this.cvuOperResultSet.setException((Exception)((Object)e));
            throw e;
        }
    }

    public VerificationResultSet checkSharedStorageAccessibility(String[] nodeList, String path, OracleFileType fileType) throws VerificationException, InvalidPathException {
        VerificationResultSet resultSet = null;
        try {
            resultSet = this.getClusterVerification().checkSharedStorageAccessibility(nodeList, path, fileType);
            this.cvuOperResultSet.setResultSet(resultSet);
        }
        catch (VerificationException e) {
            this.cvuOperResultSet.setException((Exception)((Object)e));
            throw e;
        }
        catch (InvalidPathException e) {
            this.cvuOperResultSet.setException((Exception)((Object)e));
            throw e;
        }
        return resultSet;
    }

    public SharedStorageResultSet checkSharedStorageAccessibility(String[] nodeList) throws VerificationException {
        SharedStorageResultSet resultSet = null;
        try {
            resultSet = this.getClusterVerification().checkSharedStorageAccessibility(nodeList);
            this.cvuOperResultSet.setResultSet((VerificationResultSet)resultSet);
        }
        catch (VerificationException e) {
            this.cvuOperResultSet.setException((Exception)((Object)e));
            throw e;
        }
        return resultSet;
    }

    public boolean checkRootUserPassword(String[] nodeList, String password) {
        VerificationResultSet resultSet = null;
        try {
            resultSet = this.getClusterVerification().checkRootPassword(nodeList, password);
            this.cvuOperResultSet.setResultSet(resultSet);
            if (resultSet != null && resultSet.getOverallStatus() == OverallStatus.SUCCESSFUL) {
                return true;
            }
        }
        catch (VerificationException e) {
            this.cvuOperResultSet.setException((Exception)((Object)e));
        }
        return false;
    }

    public boolean checkSudoExistance(String[] nodeList, String sudoLocation, String userName, String password) {
        VerificationResultSet resultSet = null;
        try {
            resultSet = this.getClusterVerification().checkSudoExistence(nodeList, sudoLocation, userName, password);
            this.cvuOperResultSet.setResultSet(resultSet);
            if (resultSet != null && resultSet.getOverallStatus() == OverallStatus.SUCCESSFUL) {
                return true;
            }
        }
        catch (VerificationException e) {
            this.cvuOperResultSet.setException((Exception)((Object)e));
        }
        return false;
    }

    public boolean checkSudoExecution(String[] nodeList, String sudoLocation, String userName, String password) {
        VerificationResultSet resultSet = null;
        try {
            resultSet = this.getClusterVerification().checkSudoExecution(nodeList, sudoLocation, userName, password);
            this.cvuOperResultSet.setResultSet(resultSet);
            if (resultSet != null && resultSet.getOverallStatus() == OverallStatus.SUCCESSFUL) {
                return true;
            }
        }
        catch (VerificationException e) {
            this.cvuOperResultSet.setException((Exception)((Object)e));
        }
        return false;
    }

    public boolean checkPBRunExistance(String[] nodeList, String pbRunLocation, String userName, String password) {
        VerificationResultSet resultSet = null;
        try {
            resultSet = this.getClusterVerification().checkPbrunExistence(nodeList, pbRunLocation, userName, password);
            this.cvuOperResultSet.setResultSet(resultSet);
            if (resultSet != null && resultSet.getOverallStatus() == OverallStatus.SUCCESSFUL) {
                return true;
            }
        }
        catch (VerificationException e) {
            this.cvuOperResultSet.setException((Exception)((Object)e));
        }
        return false;
    }

    public boolean checkPBRunExecution(String[] nodeList, String pbRunLocation, String userName, String password) {
        VerificationResultSet resultSet = null;
        try {
            resultSet = this.getClusterVerification().checkPbrunExecution(nodeList, pbRunLocation, userName, password);
            this.cvuOperResultSet.setResultSet(resultSet);
            if (resultSet != null && resultSet.getOverallStatus() == OverallStatus.SUCCESSFUL) {
                return true;
            }
        }
        catch (VerificationException e) {
            this.cvuOperResultSet.setException((Exception)((Object)e));
        }
        return false;
    }

    public VerificationResultSet checkFrameworkSetup(String ... nodeList) throws VerificationException {
        try {
            VerificationResultSet resultSet = nodeList == null || nodeList.length == 0 ? this.getClusterVerification().checkFrameworkSetup() : this.getClusterVerification().checkFrameworkSetup(nodeList);
            this.cvuOperResultSet.setResultSet(resultSet);
            return resultSet;
        }
        catch (VerificationException e) {
            this.cvuOperResultSet.setException((Exception)((Object)e));
            throw e;
        }
    }

    public void setRootExecutionInfo(ConfigurationSetup.ConfigMethod execMode, UserInfo creds, String location) {
        try {
            if (execMode == ConfigurationSetup.ConfigMethod.ROOT) {
                this.getClusterVerification().setRootExecutionInfo(execMode, creds);
            } else {
                this.getClusterVerification().setRootExecutionInfo(execMode, creds, location);
            }
        }
        catch (VerificationException e) {
            this.cvuOperResultSet.setException((Exception)((Object)e));
            logger.log(Level.SEVERE, "Verification exception occured while setting root execution information", e);
        }
    }

    public String getSudoPath() {
        try {
            return this.getClusterVerification().getSudoLocation();
        }
        catch (VerificationException e) {
            this.cvuOperResultSet.setException((Exception)((Object)e));
            logger.log(Level.SEVERE, "Verification exception occured while getting sudo path");
            return null;
        }
    }

    public boolean checkUserExistance(String user, List<String> nodes) {
        try {
            VerificationResultSet resultSet = this.getClusterVerification().checkUserExistence(nodes.toArray(new String[0]), user);
            this.cvuOperResultSet.setResultSet(resultSet);
            if (resultSet != null && resultSet.getOverallStatus() == OverallStatus.SUCCESSFUL) {
                return true;
            }
            logger.log(Level.WARNING, "User existance check failed with overall status:" + resultSet.getOverallStatus() + " failed nodes:" + resultSet.getFailedNodes());
        }
        catch (VerificationException e) {
            logger.log(Level.INFO, "failed to check the user existance on the specified nodes:" + nodes);
            this.cvuOperResultSet.setException((Exception)((Object)e));
        }
        return false;
    }

    public boolean checkGroupMemberShip(String user, String group, List<String> nodes) {
        try {
            VerificationResultSet resultSet = this.getClusterVerification().checkGroupMembership(nodes.toArray(new String[0]), user, group, false);
            this.cvuOperResultSet.setResultSet(resultSet);
            if (resultSet != null && resultSet.getOverallStatus() == OverallStatus.SUCCESSFUL) {
                return true;
            }
            logger.log(Level.WARNING, "User existance check failed with overall status:" + resultSet.getOverallStatus() + " failed nodes:" + resultSet.getFailedNodes());
        }
        catch (VerificationException e) {
            logger.log(Level.INFO, "failed to check the user group memebership on the given nodes:" + nodes);
            this.cvuOperResultSet.setException((Exception)((Object)e));
        }
        return false;
    }

    public List<VerificationTask> getPreReqTasksForRACNodeAdd(String[] nodeList, String crsHome) throws PreReqNotSupportedException, VerificationException {
        return this.getClusterVerification().getPreReqTasksForRACNodeAdd(nodeList, crsHome);
    }

    class CVUOperationResultSet {
        private VerificationResultSet resultSet;
        private VerificationResult result;
        private Exception e;

        public VerificationResultSet getResultSet() {
            return this.resultSet;
        }

        public void setResultSet(VerificationResultSet resultSet) {
            this.resultSet = resultSet;
        }

        public Exception getException() {
            return this.e;
        }

        public void setException(Exception e) {
            this.e = e;
        }

        public void setResult(VerificationResult result) {
            this.result = result;
        }

        public VerificationResult getResult() {
            return this.result;
        }
    }
}

